<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;

    public function project()
    {
        return $this->belongsTo('App\Models\Project');
    }

    public function paper()
    {
        return $this->hasMany('App\Models\Paper');
    }

    public function assessor()
    {
        return $this->belongsTo('User', 'assessor_id');
    }

    public function followers()
    {
        return $this->hasMany('App\Models\TaskFollower');
    }

    public function status()
    {
        return $this->belongsTo('App\Models\TaskStatus');
    }

    public function paperAnswers()
    {
        return $this->hasMany('App\Models\PaperAnswers');
    }

}